/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.HscTransaction;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class HscPerformance {
    private static final String DEFAULT_LOG_FILE = "/var/hsc/log/cimperformance.log";
    private static Hashtable threadHash = new Hashtable();
    private static boolean enabled = false;
    private static FileOutputStream outStream = null;

    public static void createInstance(String string) throws FileNotFoundException {
        HscPerformance.createInstance(false, string);
    }

    public static synchronized void createInstance(boolean bl, String string) throws FileNotFoundException {
        if (null == outStream) {
            if (null == string) {
                string = DEFAULT_LOG_FILE;
            }
            outStream = new FileOutputStream(string, false);
            enabled = bl;
            HscTransaction.setOutput(outStream);
        }
    }

    public static boolean enable() {
        if (null == outStream) {
            return enabled;
        }
        try {
            HscTransaction.logChange(0);
            enabled = true;
        }
        catch (IOException iOException) {
            HscPerformance.forceDisable();
        }
        return enabled;
    }

    private static void forceDisable() {
        enabled = false;
        outStream = null;
        threadHash.clear();
        System.err.println("Performance logging is disabled");
    }

    public static void disable() {
        enabled = false;
        threadHash.clear();
        try {
            HscTransaction.logChange(1);
        }
        catch (IOException iOException) {
            outStream = null;
            System.err.println("Performance logging is disabled");
        }
    }

    private static HscTransaction findTransaction(LinkedList linkedList, int n) {
        int n2 = linkedList.size() - 1;
        while (n2 >= 0) {
            HscTransaction hscTransaction = (HscTransaction)linkedList.get(n2);
            if (hscTransaction.getId() == n) {
                return hscTransaction;
            }
            --n2;
        }
        return null;
    }

    private static LinkedList getTransactionList(Thread thread) {
        if (null == thread) {
            thread = Thread.currentThread();
        }
        return (LinkedList)threadHash.get(thread);
    }

    private static int getTransactionId() {
        int n;
        LinkedList linkedList = HscPerformance.getTransactionList(null);
        if (null == linkedList) {
            n = -1;
        } else {
            HscTransaction hscTransaction = (HscTransaction)linkedList.getLast();
            n = hscTransaction.getId();
        }
        return n;
    }

    public static void terminateAllTransactions() {
        HscTransaction hscTransaction;
        Thread thread = Thread.currentThread();
        LinkedList linkedList = HscPerformance.getTransactionList(thread);
        if (null == linkedList) {
            return;
        }
        threadHash.remove(thread);
        while (null != (hscTransaction = (HscTransaction)linkedList.removeLast())) {
            try {
                hscTransaction.endTransaction(2);
            }
            catch (IOException iOException) {
                HscPerformance.forceDisable();
                return;
            }
        }
    }

    public static int startTransaction(String string) {
        int n;
        if (!enabled) {
            return -1;
        }
        Thread thread = Thread.currentThread();
        LinkedList<HscTransaction> linkedList = HscPerformance.getTransactionList(thread);
        if (null == linkedList) {
            n = 0;
        } else {
            HscTransaction hscTransaction = (HscTransaction)linkedList.getLast();
            n = hscTransaction.getId();
        }
        boolean bl = false;
        HscTransaction hscTransaction = null;
        try {
            hscTransaction = new HscTransaction(string, thread.getName(), n);
        }
        catch (IOException iOException) {
            HscPerformance.forceDisable();
            return -1;
        }
        if (null == linkedList) {
            linkedList = new LinkedList<HscTransaction>();
            threadHash.put(thread, linkedList);
        }
        linkedList.add(hscTransaction);
        return hscTransaction.getId();
    }

    private static void handleTransaction(int n, String string) {
        if (!enabled) {
            return;
        }
        Thread thread = Thread.currentThread();
        LinkedList linkedList = HscPerformance.getTransactionList(thread);
        if (null == linkedList) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                HscTransaction hscTransaction = (HscTransaction)linkedList.removeLast();
                if (0 == linkedList.size()) {
                    threadHash.remove(thread);
                }
                try {
                    hscTransaction.endTransaction(n);
                }
                catch (IOException iOException) {
                    HscPerformance.forceDisable();
                }
                break;
            }
            case 20: {
                HscTransaction hscTransaction = (HscTransaction)linkedList.getLast();
                try {
                    hscTransaction.heartBeat(string);
                }
                catch (IOException iOException) {
                    HscPerformance.forceDisable();
                }
                break;
            }
            case 21: 
            case 22: {
                HscTransaction hscTransaction = (HscTransaction)linkedList.getLast();
                try {
                    hscTransaction.changeState(n);
                }
                catch (IOException iOException) {
                    HscPerformance.forceDisable();
                }
                break;
            }
        }
    }

    private static void handleTransaction(int n, int n2, String string) {
        if (!enabled) {
            return;
        }
        Thread thread = Thread.currentThread();
        LinkedList linkedList = HscPerformance.getTransactionList(thread);
        if (null == linkedList) {
            return;
        }
        HscTransaction hscTransaction = HscPerformance.findTransaction(linkedList, n);
        if (null == hscTransaction) {
            return;
        }
        boolean bl = true;
        boolean bl2 = false;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                HscTransaction hscTransaction2 = (HscTransaction)linkedList.getLast();
                while (hscTransaction2 != hscTransaction) {
                    try {
                        hscTransaction2.endTransaction(3);
                    }
                    catch (IOException iOException) {
                        HscPerformance.forceDisable();
                        return;
                    }
                    linkedList.removeLast();
                    hscTransaction2 = (HscTransaction)linkedList.getLast();
                }
                linkedList.removeLast();
                if (0 == linkedList.size()) {
                    threadHash.remove(thread);
                }
                if (!bl) break;
                try {
                    hscTransaction.endTransaction(n2);
                    break;
                }
                catch (IOException iOException) {
                    HscPerformance.forceDisable();
                    return;
                }
            }
            case 20: {
                try {
                    hscTransaction.heartBeat(string);
                }
                catch (IOException iOException) {
                    HscPerformance.forceDisable();
                }
                break;
            }
            case 21: 
            case 22: {
                try {
                    hscTransaction.changeState(n2);
                }
                catch (IOException iOException) {
                    HscPerformance.forceDisable();
                }
                break;
            }
        }
    }

    public static void endTransaction(int n, int n2) {
        HscPerformance.handleTransaction(n, n2, null);
    }

    public static void endTransaction() {
        HscPerformance.handleTransaction(0, null);
    }

    public static void endTransaction(int n) {
        HscPerformance.handleTransaction(n, 0, null);
    }

    public static void updateTransaction(int n, String string) {
        HscPerformance.handleTransaction(n, 20, string);
    }

    public static void updateTransaction(String string) {
        HscPerformance.handleTransaction(20, string);
    }

    public static void cancelTransaction() {
        HscPerformance.handleTransaction(2, null);
    }

    public static void cancelTransaction(int n) {
        HscPerformance.handleTransaction(n, 2, null);
    }

    public static void resumeTransaction(int n) {
        HscPerformance.handleTransaction(n, 21, null);
    }

    public static void resumeTransaction() {
        HscPerformance.handleTransaction(21, null);
    }

    public static void suspendTransaction(int n) {
        HscPerformance.handleTransaction(n, 22, null);
    }

    public static void suspendTransaction() {
        HscPerformance.handleTransaction(22, null);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                HscPerformance.createInstance(stringArray[0]);
            } else {
                HscPerformance.createInstance("zz");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("unable to open performance timing file");
        }
        int n = HscPerformance.startTransaction("1");
        System.out.println("id = " + n);
        HscPerformance.dumpList("not enabled");
        HscPerformance.enable();
        int n2 = HscPerformance.startTransaction("2");
        HscPerformance.dumpList("show 1");
        int n3 = HscPerformance.startTransaction("3");
        HscPerformance.resumeTransaction(n2);
        HscPerformance.suspendTransaction(n2);
        int n4 = HscPerformance.startTransaction("4");
        int n5 = HscPerformance.startTransaction("5");
        HscPerformance.resumeTransaction(n2);
        HscPerformance.suspendTransaction(n4);
        HscPerformance.suspendTransaction();
        HscPerformance.dumpList("show suspended - 3");
        HscPerformance.updateTransaction("xxx: ");
        HscPerformance.updateTransaction(n, null);
        HscPerformance.updateTransaction(n2, "Heartbeat info: ");
        HscPerformance.resumeTransaction();
        HscPerformance.endTransaction(n4, 1);
        HscPerformance.resumeTransaction(n4);
        HscPerformance.dumpList("should have 1 and 2");
        HscPerformance.cancelTransaction(n2);
        HscPerformance.dumpList("empty dump");
        System.out.println("end with no hash entries");
        HscPerformance.endTransaction();
    }

    private static void dumpList(String string) {
        System.out.println(string);
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = threadHash.keys();
        while (enumeration.hasMoreElements()) {
            Thread thread = (Thread)enumeration.nextElement();
            LinkedList linkedList = (LinkedList)threadHash.get(thread);
            System.out.println(thread.toString());
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                HscTransaction hscTransaction = (HscTransaction)listIterator.next();
                System.out.println("   " + hscTransaction.toString());
            }
        }
        System.out.println("");
    }
}

